@extends('layouts.master')

@section('content')
    @section('title')
    @endsection
    <style>
        ul li.active,
        a.active {
            color: #3fbbc0;
        }

        tr:nth-child(even) tr {background: #ffffff !important;}

    </style>
    <div class="" role="main">
        <div class="">
            <div class="page-title">
                <div class="title_left">
                    <h3>{{$header['pageTitle']}}  <a href="{{url('/home')}}">Dashboard</a></h3>
                </div>
            </div>
            <div class="clearfix"></div>
            <div class="row">
                <div class="col-md-12 col-sm-12 col-lg-12">
                    <div class="x_panel">
                        <div class="x_title" style="border:none;">
                            <h2>{{$header['tableTitle']}} </h2>
                        </div>
                        <div class="x_content">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card-box table-responsive">
                                        <table id="datatable" class="table table-striped table-bordered dataTable"
                                               role="grid" aria-describedby="data-table-info" width="100%">
                                            <thead style="background-color: #0b58a2; color: white">
                                            <tr>
                                                <th>Sl</th>
                                                <th>Task Info</th>
                                                <th>Task Description</th>
                                                <th class="text-center">Task Info</th>
                                                @if(Auth::user()->is_admin !=1)
                                                    <th>W.Status</th>
                                                    <th>Action</th>
                                                @endif
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($results as $key=> $result)
                                                <tr @if($result->task_complete > 0 && $result->task_create_date ==date('Y-m-d'))style="background-color: #e4f0e9" @endif>
                                                    <td>{{$key+1}}</td>
                                                    {{--                                                <td>{{$result->project_name}}</td>--}}
                                                    <td style="width: 27%!important;">
                                                        <table class="table table-striped tblTimeCalc" width="100%">
                                                            @if(!empty($result->project_name))
                                                                <tr class="" @if($result->task_complete > 0 && $result->task_create_date ==date('Y-m-d'))style="background-color: #e4f0e9 !important;" @else style="background-color: #f2f2f2" @endif>
                                                                    <td><strong>Project</strong></td>
                                                                    <td><strong>:</strong></td>
                                                                    <td>{{$result->project_name}}</td>
                                                                </tr>
                                                            @endif
                                                            @if(!empty($result->task_title))
                                                                <tr class="" @if($result->task_complete > 0 && $result->task_create_date ==date('Y-m-d'))style="background-color: #e4f0e9 !important;" @else style="background-color: #f2f2f2" @endif>
                                                                    <td><strong>Task Title</strong></td>
                                                                    <td><strong>:</strong></td>
                                                                    <td>{{$result->task_title}}</td>
                                                                </tr>
                                                            @endif
                                                            @if(!empty($result->task_category))
                                                                <tr class="" @if($result->task_complete > 0 && $result->task_create_date ==date('Y-m-d'))style="background-color: #e4f0e9 !important;" @else style="background-color: #f2f2f2" @endif>
                                                                    <td><strong>Task Category</strong></td>
                                                                    <td><strong>:</strong></td>
                                                                    <td>{{$result->task_category_name}}</td>
                                                                </tr>
                                                            @endif
                                                            <tr class="" @if($result->task_complete > 0 && $result->task_create_date ==date('Y-m-d'))style="background-color: #e4f0e9 !important;" @else style="background-color: #f2f2f2" @endif>
                                                                <td><strong>Assign By</strong></td>
                                                                <td><strong>:</strong></td>
                                                                <td>
                                                                    @if(!empty($result->assign_by_name))
                                                                        {{ $result->assign_by_name }}
                                                                    @else
                                                                        {{ $result->assign_person_name }}
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            <tr class="" @if($result->task_complete > 0 && $result->task_create_date ==date('Y-m-d'))style="background-color: #e4f0e9 !important;" @else style="background-color: #f2f2f2" @endif>
                                                                <td><strong>Respective  Person</strong></td>
                                                                <td><strong>:</strong></td>
                                                                <td>
                                                                    @if(!empty($result->employee_name))
                                                                        {{ $result->employee_name }}
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </td>

                                                    <td>{{$result->task_desc}}</td>
                                                    <style>
                                                        .tblTimeCalc td{
                                                            border: none !important;
                                                            border-top: none !important;
                                                            border-bottom: none !important;
                                                        }

                                                        .tblTaskCalc td, .tblTaskCalc th{
                                                            border: 1px solid #ccc !important;
                                                            background-color: #f7ffe9 !important;
                                                            padding:2px 4px !important;
                                                        }

                                                        .tblTaskCalc{

                                                            font-size:12px !important;
                                                        }
                                                    </style>
                                                    <td style="width: 27%!important;">
                                                        <table class="table table-striped tblTimeCalc" width="100%">
                                                            @if(!empty($result->priority_name))
                                                                <tr class="" @if($result->task_complete > 0 && $result->task_create_date ==date('Y-m-d'))style="background-color: #e4f0e9 !important;" @else style="background-color: #f2f2f2" @endif>
                                                                    <td><strong>Priority</strong></td>
                                                                    <td><strong>:</strong></td>
                                                                    <td>{{$result->priority_name}}</td>
                                                                </tr>
                                                            @endif
                                                            <tr class="" @if($result->task_complete > 0 && $result->task_create_date ==date('Y-m-d'))style="background-color: #e4f0e9 !important;" @else style="background-color: #f2f2f2" @endif>
                                                                <td><strong>Assign Date</strong></td>
                                                                <td><strong>:</strong></td>
                                                                <td>
                                                                    @php
                                                                        $today = date('Y-m-d');
                                                                        $foCheDate = date('Y-m-d');
                                                                    @endphp
                                                                    @if(!empty($result->assign_date))
                                                                        {{ date('d-M-Y',strtotime($result->assign_date)) }}
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            <tr  class="" @if($result->task_complete > 0 && $result->task_create_date ==date('Y-m-d'))style="background-color: #e4f0e9 !important;" @else style="background-color: #f2f2f2" @endif>
                                                                <input type="hidden" class="checkForeCastDate" value="{{date('Y-m-d',strtotime($result->forecast_date))}}"/>
                                                                <input type="hidden" class="checkCurrentDate" value="{{date('Y-m-d')}}"/>
                                                                <td @if(date('Y-m-d',strtotime($result->forecast_date)) < $foCheDate)style="color: red; @endif"><strong>Forecast Date</strong></td>
                                                                <td @if(date('Y-m-d',strtotime($result->forecast_date)) < $foCheDate)style="color: red; @endif"><strong>:</strong></td>
                                                                <td @if(date('Y-m-d',strtotime($result->forecast_date)) < $foCheDate)style="color: red; @endif">{{ !empty($result->forecast_date)?date('d-M-Y',strtotime($result->forecast_date)):'' }}</td>
                                                            </tr>
                                                            <tr  class="" @if($result->task_complete > 0 && $result->task_create_date ==date('Y-m-d'))style="background-color: #e4f0e9 !important;" @else style="background-color: #f2f2f2" @endif>
                                                                <td colspan="3">
                                                                    @php
                                                                        $taskTime = DB::table('npoly_task_report_log')
                                                                                    ->select('start_time','end_time')
                                                                                    ->where('task_id',$result->task_id)
                                                                                    ->where('prof_task_perfome_dt',date('Y-m-d'))
                                                                                    ->get();
                                                                        $timeCount = count($taskTime);
                                                                    @endphp

                                                                    @if($timeCount > 0 && $result->task_create_date==date('Y-m-d'))
                                                                        <table class="tblTaskCalc" width="100%">
                                                                            <tbody><tr>
                                                                                <th colspan="3" class="text-center" style="background-color:#e3e3cd !important"><b>Task Timing</b></th>
                                                                            </tr>
                                                                            <tr>
                                                                                <th title="Start Time"><b>Start</b></th>
                                                                                <th title="End Time"><b>End</b></th>
                                                                                <th title="Total Time"><b>Total</b></th>
                                                                            </tr>

                                                                            @foreach($taskTime as $ttm)
                                                                                <tr>
                                                                                    <td>{{gmdate('h:i A',$ttm->start_time)}}</td>
                                                                                    <td>
                                                                                        @if($ttm->end_time > $ttm->start_time){{gmdate('h:i A',$ttm->end_time)}} @endif
                                                                                    </td>
                                                                                    <td>
                                                                                        @php
                                                                                            if($ttm->end_time > $ttm->start_time){
                                                                                              $datetime1 = new DateTime(gmdate('h:i A',$ttm->start_time));
                                                                                             $datetime2 = new DateTime(gmdate('h:i A',$ttm->end_time));
                                                                                             $interval = $datetime1->diff($datetime2);
                                                                                             echo $interval->format('%h')." H ".$interval->format('%i')." M";
                                                                                            }

                                                                                        @endphp
                                                                                    </td>
                                                                                </tr>
                                                                            @endforeach
                                                                            </tbody></table>
                                                                    @else
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            <tr class="" @if($result->task_complete > 0 && $result->task_create_date ==date('Y-m-d'))style="background-color: #e4f0e9 !important;" @else style="background-color: #f2f2f2" @endif>
                                                                <td><strong>Task Type</strong></td>
                                                                <td><strong>:</strong></td>
                                                                <td>
                                                                    @if($result->assign_date == $today)
                                                                        {{'New'}}
                                                                    @else
                                                                        {{'Old'}}
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            @if($result->task_complete > 0)
                                                                <tr class="" @if($result->task_complete > 0 && $result->task_create_date ==date('Y-m-d'))style="background-color: #e4f0e9 !important;"@else style="background-color: #f2f2f2"  @endif>
                                                                    <td @if($result->task_complete==100) style="color: green; @endif"><strong>Task Done</strong></td>
                                                                    <td  @if($result->task_complete==100) style="color: green; @endif"><strong>:</strong></td>
                                                                    <td  @if($result->task_complete==100) style="color: green; @endif">{{$result->task_complete}}% </td>
                                                                </tr>
                                                            @endif
                                                        </table>

                                                    </td>
                                                    {{--                                                <td>{{date('d-M-Y',strtotime($result->forecast_date))}}</td>--}}
                                                    @if(Auth::user()->is_admin !=1)
                                                        <td>
                                                            <button @if($result->task_complete=='100') disabled @endif class=" @if($result->task_running=='1') btn btn-warning @else btn btn-success @endif taskStatus" value="{{$result->task_running}}">@if($result->task_running =='1') Stop @else Start @endif </button>
                                                            <input type="hidden" class="taskId" value="{{$result->task_id }}" id="taskId">
                                                        </td>
                                                        <td class="text-center">
                                                            <button type="button" @if($result->task_running=='1' || $result->task_complete=='100') disabled  @endif class="btn btn-info btn-sm dynamicModal"
                                                                    pageTitle="Update Task"
                                                                    pageLink="{{url('/updateTask/'.$result->task_id)}}"
                                                                    data-modal-size="modal-xl" data-toggle="tooltip"
                                                                    data-placement="top" title="@if($result->task_running=='1') Stop The Task Then Update @else Update Task @endif">
                                                                <i class="glyphicon glyphicon-edit"></i>
                                                            </button>
                                                        </td>
                                                    @endif
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
